$(function () {
    $("#cari_data").on({
        keypress: function () {
            typed_into = true;
        },
        change: function () {
            var kode = $("#cari_data").val();
            var token = $("meta[name='csrf-token']").attr("content");
            if (kode == null) {
                $("#cari_data").focus();
                $("#cari_data").val("");
            } else {
                $.ajax({
                    type: "POST",
                    url: "kode-produk",
                    dataType: "JSON",
                    data: {
                        kode: kode,
                        _token: token,
                    },
                    success: function (data) {
                        if (data.hasil == "ada") {
                            $("#cari_data").val("");
                            $("#jml").prop("disabled", false);
                            $("#jml").val("");
                            $("#jml").focus();
                            $(".produk").remove();
                            $("#kd").html(data.kd);
                            $("#nm").html(data.nm);
                            $("#idp").val(data.idp);
                        } else if (data.hasil == "kosong") {
                            nama_produk(kode);
                        }
                    },
                });
            }
        },
    });

    function nama_produk(nama) {
        var token = $("meta[name='csrf-token']").attr("content");
        if (nama == null) {
            $("#cari_data").focus();
            $("#cari_data").val("");
        } else {
            $.ajax({
                type: "post",
                url: "cari-produk",
                data: {
                    nama: nama,
                    _token: token,
                },
                success: function (data) {
                    if (data == "kosong") {
                        toastr.info("Produk tidak terdaftar .");
                        $(".produk").remove();
                        $("#cari_data").focus();
                        $("#jml").val("");
                        $("#jml").prop("disabled", true);
                    } else {
                        $(".produk").remove();
                        $(".show").append(
                            '<div class="produk"><ul class="list-group">' +
                                data +
                                "</ul></div>"
                        );
                    }
                },
            });
        }
    }

    $(".show").on("click", ".pilih", function () {
        var kode = $(this).attr("data-kd");
        var token = $("meta[name='csrf-token']").attr("content");
        $.ajax({
            type: "POST",
            url: "kode-produk",
            dataType: "JSON",
            data: {
                kode: kode,
                _token: token,
            },
            success: function (data) {
                $(".produk").remove();
                $("#kd").html(data.kd);
                $("#nm").html(data.nm);
                $("#idp").val(data.idp);

                $("#jml").prop("disabled", false);
                $("#jml").val("");
                $("#jml").focus();
            },
        });
    });

    $(".simpan").click(function (e) {
        e.preventDefault();
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $("#idp").val();
        var jml = $("#jml").val();

        if (id == "") {
            $("#cari_data").focus();
        } else if (jml == "") {
            $("#jml").focus();
        } else {
            $.ajax({
                type: "POST",
                url: "simpan-stok",
                data: {
                    id: id,
                    jml: jml,
                    _token: token,
                },
                success: function (data) {
                    Swal.fire({
                        icon: "success",
                        title: "Berhasil",
                        text: "Data Stok Masuk berhasil disimpan!",
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.location.href = "";
                        }
                    });
                },
            });
        }
    });

    $("#view").on("click", ".hapus", function () {
        // alert();
        var id = $(this).attr("data-id");
        var nama = $(this).attr("data-nm");

        Swal.fire({
            title: "Apa anda yakin?",
            text: "Stok Masuk Produk ( " + nama + " )  akan di hapus!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Ya, Hapus!",
        }).then((result) => {
            if (result.isConfirmed) {
                document.location.href = "delete-stok/" + id;
            }
        });
    });

    // ceklis
    $("#cekall").change(function () {
        if ($(this).prop("checked")) {
            $(".ceklis").prop("checked", true);
        } else {
            $(".ceklis").prop("checked", false);
        }
    });

    $("#pilih_hapus").click(function () {
        var allVals = [];
        $(".ceklis:checked").each(function () {
            allVals.push($(this).val());
        });
        var token = $("meta[name='csrf-token']").attr("content");

        if (allVals.length <= 0) {
            Toast.fire({
                icon: "error",
                title: "Ceklis data yang akan dihapus!!!.",
            });
        } else {
            Swal.fire({
                title: "Pastikan dengan benar!",
                text: "Data yang anda pilih akan dihapus!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Ya, Hapus!",
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: "deleteall-stok",
                        data: {
                            allVals: allVals,
                            _token: token,
                        },
                        beforeSend: function () {
                            $("#pilih_hapus").html(
                                '<i class="fas fa-spinner fa-spin"></i> Tunggu..'
                            );
                            $("#pilih_hapus").attr("disabled", true);
                        },
                        success: function (data) {
                            // alert(data)
                            $("#pilih_hapus").html(
                                '<i class="fa fa-trash"></i> Hapus'
                            );
                            $("#pilih_hapus").attr("disabled", true);
                            Swal.fire({
                                icon: "success",
                                title: "Berhasil",
                                text: "Data berhasil dihapus!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    document.location.href = "";
                                }
                            });
                        },
                    });
                }
            });
        }
    });
});
